/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger.dangerous;

import com.wardanger.dangerous.DangerousConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PillagerWeaponManager {
    private static final Map<UUID, Boolean> MELEE_MODE = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> LAST_SWITCH_TICK = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> LAST_MODE_CHANGE_TICK = new HashMap<UUID, Long>();
    private static final Map<UUID, ItemStack> STASHED_CROSSBOW = new HashMap<UUID, ItemStack>();
    private static final long SWITCH_COOLDOWN_TICKS = 20L;
    private static final long MODE_LOCK_TICKS = 120L;
    private static final double MELEE_IN = 6.0;
    private static final double MELEE_OUT = 12.0;
    private static final String TAG_PILLAGER_MELEE_GIVEN = "dangerous_pillager_melee_given";
    private static final String TAG_VINDICATOR_UPGRADED_AXE = "dangerous_vindicator_upgraded";
    private static final double VINDICATOR_DIAMOND_AXE_CHANCE = 0.05;

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Pillager) {
            Pillager pillager = (Pillager)livingEntity;
            PillagerWeaponManager.maybeGivePillagerMeleeOnce(pillager);
            long now = pillager.m_9236_().m_46467_();
            UUID id = pillager.m_20148_();
            if (now - LAST_SWITCH_TICK.getOrDefault(id, 0L) >= 20L && now - LAST_MODE_CHANGE_TICK.getOrDefault(id, 0L) >= 120L) {
                PillagerWeaponManager.updatePillager(pillager, now);
                LAST_SWITCH_TICK.put(id, now);
            }
        } else {
            livingEntity = event.getEntity();
            if (livingEntity instanceof Vindicator) {
                Vindicator vindicator = (Vindicator)livingEntity;
                PillagerWeaponManager.maybeUpgradeVindicatorOnce(vindicator);
            }
        }
    }

    private static void maybeGivePillagerMeleeOnce(Pillager p) {
        CompoundTag tag = p.getPersistentData();
        if (tag.m_128471_(TAG_PILLAGER_MELEE_GIVEN)) {
            return;
        }
        if (PillagerWeaponManager.hasMeleeWeaponConsideringBanner(p)) {
            tag.m_128379_(TAG_PILLAGER_MELEE_GIVEN, true);
            return;
        }
        ItemStack off = p.m_21206_();
        if (!PillagerWeaponManager.isOminousBanner(off) && (off.m_41619_() || PillagerWeaponManager.isCrossbow(off))) {
            double chance = (Double)DangerousConfig.CONFIG.weaponChance.get();
            if (p.m_217043_().m_188500_() < chance) {
                ItemStack melee;
                ItemStack itemStack = melee = p.m_217043_().m_188499_() ? new ItemStack((ItemLike)Items.f_42383_) : new ItemStack((ItemLike)Items.f_42386_);
                if (PillagerWeaponManager.isCrossbow(off)) {
                    p.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                p.m_8061_(EquipmentSlot.OFFHAND, melee);
            }
        }
        tag.m_128379_(TAG_PILLAGER_MELEE_GIVEN, true);
    }

    private static void maybeUpgradeVindicatorOnce(Vindicator v) {
        CompoundTag tag = v.getPersistentData();
        if (tag.m_128471_(TAG_VINDICATOR_UPGRADED_AXE)) {
            return;
        }
        ItemStack main = v.m_21205_();
        if (main.m_41720_() == Items.f_42386_ && v.m_217043_().m_188500_() < 0.05) {
            v.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42391_));
        }
        tag.m_128379_(TAG_VINDICATOR_UPGRADED_AXE, true);
    }

    private static void updatePillager(Pillager mob, long nowTick) {
        boolean wantMelee = PillagerWeaponManager.shouldGoMelee(mob, PillagerWeaponManager.hasMeleeWeaponConsideringBanner(mob));
        UUID id = mob.m_20148_();
        boolean curMelee = MELEE_MODE.getOrDefault(id, false);
        if (curMelee != wantMelee) {
            if (wantMelee) {
                PillagerWeaponManager.switchToMelee(mob);
            } else {
                PillagerWeaponManager.switchToRanged(mob);
            }
            MELEE_MODE.put(id, wantMelee);
            LAST_MODE_CHANGE_TICK.put(id, nowTick);
        }
    }

    private static boolean shouldGoMelee(Pillager mob, boolean hasMelee) {
        if (!hasMelee) {
            return false;
        }
        LivingEntity tgt = mob.m_5448_();
        boolean nowMelee = MELEE_MODE.getOrDefault(mob.m_20148_(), false);
        if (tgt == null || !tgt.m_6084_()) {
            List players = mob.m_9236_().m_6443_(Player.class, mob.m_20191_().m_82400_(6.0), EntitySelector.f_20408_);
            return !players.isEmpty();
        }
        double d = mob.m_20270_((Entity)tgt);
        if (!nowMelee) {
            return mob.m_142582_((Entity)tgt) && d <= 6.0;
        }
        return !(d <= 12.0);
    }

    private static void switchToMelee(Pillager mob) {
        UUID id = mob.m_20148_();
        ItemStack main = mob.m_21205_();
        ItemStack off = mob.m_21206_();
        if (PillagerWeaponManager.isCrossbow(main)) {
            STASHED_CROSSBOW.put(id, main.m_41777_());
            mob.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        if (!PillagerWeaponManager.isOminousBanner(off) && PillagerWeaponManager.isCrossbow(off)) {
            STASHED_CROSSBOW.put(id, off.m_41777_());
            mob.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        }
        main = mob.m_21205_();
        off = mob.m_21206_();
        if (!PillagerWeaponManager.isMelee(main) && PillagerWeaponManager.isMelee(off) && !PillagerWeaponManager.isOminousBanner(off)) {
            mob.m_8061_(EquipmentSlot.MAINHAND, off.m_41777_());
            mob.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        }
        PillagerWeaponManager.forceAttackModeMelee(mob);
    }

    private static void switchToRanged(Pillager mob) {
        ItemStack bow;
        UUID id = mob.m_20148_();
        ItemStack main = mob.m_21205_();
        ItemStack off = mob.m_21206_();
        if (PillagerWeaponManager.isMelee(main)) {
            if (PillagerWeaponManager.isOminousBanner(off)) {
                PillagerWeaponManager.forceAttackModeMelee(mob);
                return;
            }
            if (off.m_41619_() || PillagerWeaponManager.isCrossbow(off)) {
                if (PillagerWeaponManager.isCrossbow(off)) {
                    mob.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                mob.m_8061_(EquipmentSlot.OFFHAND, main.m_41777_());
                mob.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
        if ((bow = STASHED_CROSSBOW.getOrDefault(id, ItemStack.f_41583_)).m_41619_()) {
            if (PillagerWeaponManager.isCrossbow(mob.m_21205_())) {
                bow = mob.m_21205_().m_41777_();
            } else if (PillagerWeaponManager.isCrossbow(mob.m_21206_()) && !PillagerWeaponManager.isOminousBanner(mob.m_21206_())) {
                bow = mob.m_21206_().m_41777_();
            }
        }
        if (!bow.m_41619_()) {
            mob.m_8061_(EquipmentSlot.MAINHAND, bow.m_41777_());
            STASHED_CROSSBOW.remove(id);
        }
        if (!PillagerWeaponManager.isOminousBanner(mob.m_21206_()) && PillagerWeaponManager.isCrossbow(mob.m_21206_())) {
            mob.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        }
        PillagerWeaponManager.forceAttackModeRanged(mob);
    }

    private static void forceAttackModeMelee(Pillager mob) {
        mob.m_5810_();
        mob.m_6136_(false);
        mob.m_21573_().m_26573_();
        mob.m_21561_(true);
        PillagerWeaponManager.removeAllGoals(mob, RangedCrossbowAttackGoal.class);
        PillagerWeaponManager.removeAllGoals(mob, MeleeAttackGoal.class);
        mob.f_21345_.m_25352_(4, (Goal)new NoXbowMeleeGoal(mob, 1.2, false));
    }

    private static void forceAttackModeRanged(Pillager mob) {
        mob.m_5810_();
        mob.m_6136_(false);
        mob.m_21573_().m_26573_();
        mob.m_21561_(false);
        PillagerWeaponManager.removeAllGoals(mob, RangedCrossbowAttackGoal.class);
        PillagerWeaponManager.removeAllGoals(mob, MeleeAttackGoal.class);
        mob.f_21345_.m_25352_(4, (Goal)new RangedCrossbowAttackGoal((Monster)mob, 1.0, 15.0f));
    }

    private static void removeAllGoals(Pillager mob, Class<? extends Goal> type) {
        ArrayList<WrappedGoal> toRemove = new ArrayList<WrappedGoal>();
        for (WrappedGoal wg : mob.f_21345_.m_148105_()) {
            if (!type.isInstance(wg.m_26015_())) continue;
            toRemove.add(wg);
        }
        for (WrappedGoal wg : toRemove) {
            mob.f_21345_.m_25363_(wg.m_26015_());
        }
    }

    private static boolean isMelee(ItemStack s) {
        return !s.m_41619_() && (s.m_41720_() instanceof SwordItem || s.m_41720_() instanceof AxeItem);
    }

    private static boolean isCrossbow(ItemStack s) {
        return !s.m_41619_() && s.m_41720_() instanceof CrossbowItem;
    }

    private static boolean isOminousBanner(ItemStack s) {
        return !s.m_41619_() && s.m_41720_() instanceof BannerItem;
    }

    private static boolean hasMeleeWeaponConsideringBanner(Pillager m) {
        if (PillagerWeaponManager.isMelee(m.m_21205_())) {
            return true;
        }
        return PillagerWeaponManager.isMelee(m.m_21206_()) && !PillagerWeaponManager.isOminousBanner(m.m_21206_());
    }

    private static class NoXbowMeleeGoal
    extends MeleeAttackGoal {
        private final Pillager p;

        public NoXbowMeleeGoal(Pillager mob, double speed, boolean longMemory) {
            super((PathfinderMob)mob, speed, longMemory);
            this.p = mob;
        }

        public void m_8056_() {
            super.m_8056_();
            this.p.m_5810_();
            this.p.m_6136_(false);
            this.p.m_21561_(true);
            PillagerWeaponManager.removeAllGoals(this.p, RangedCrossbowAttackGoal.class);
            this.enforceMeleeHands();
        }

        public void m_8041_() {
            super.m_8041_();
            this.p.m_5810_();
            this.p.m_6136_(false);
            this.p.m_21561_(false);
        }

        public void m_8037_() {
            super.m_8037_();
            this.p.m_5810_();
            this.p.m_6136_(false);
            PillagerWeaponManager.removeAllGoals(this.p, RangedCrossbowAttackGoal.class);
            this.enforceMeleeHands();
            this.p.m_21561_(true);
        }

        private void enforceMeleeHands() {
            ItemStack main = this.p.m_21205_();
            ItemStack off = this.p.m_21206_();
            if (PillagerWeaponManager.isCrossbow(main)) {
                STASHED_CROSSBOW.put(this.p.m_20148_(), main.m_41777_());
                this.p.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
            if (PillagerWeaponManager.isCrossbow(off) && !PillagerWeaponManager.isOminousBanner(off)) {
                STASHED_CROSSBOW.put(this.p.m_20148_(), off.m_41777_());
                this.p.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
            main = this.p.m_21205_();
            off = this.p.m_21206_();
            if (!PillagerWeaponManager.isMelee(main) && PillagerWeaponManager.isMelee(off) && !PillagerWeaponManager.isOminousBanner(off)) {
                this.p.m_8061_(EquipmentSlot.MAINHAND, off.m_41777_());
                this.p.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
            if (PillagerWeaponManager.isCrossbow(this.p.m_21206_()) && !PillagerWeaponManager.isOminousBanner(this.p.m_21206_())) {
                this.p.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
        }
    }
}

